<?php

/**
 * Class that operate on table 'billoperation'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-08-14 15:43
 */
class BilloperationMySqlDAO implements BilloperationDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BilloperationMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM billoperation WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM billoperation';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM billoperation ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param billoperation primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM billoperation WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BilloperationMySql billoperation
     */
    public function insert($billoperation) {
        $sql = 'INSERT INTO billoperation (name, userid, sydate, del,treeId) VALUES (?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($billoperation->name);
        $sqlQuery->setNumber($billoperation->userid);
        $sqlQuery->set($billoperation->sydate);
        $sqlQuery->setNumber($billoperation->del);
        $sqlQuery->setNumber((int) $billoperation->treeId);

        $id = $this->executeInsert($sqlQuery);
        $billoperation->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BilloperationMySql billoperation
     */
    public function update($billoperation) {
        $sql = 'UPDATE billoperation SET name = ?, userid = ?, sydate = ?, del = ?,treeId=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($billoperation->name);
        $sqlQuery->setNumber($billoperation->userid);
        $sqlQuery->set($billoperation->sydate);
        $sqlQuery->setNumber($billoperation->del);
        $sqlQuery->setNumber((int) $billoperation->treeId);

        $sqlQuery->setNumber($billoperation->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM billoperation';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM billoperation WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM billoperation WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySydate($value) {
        $sql = 'SELECT * FROM billoperation WHERE sydate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM billoperation WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM billoperation WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM billoperation WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySydate($value) {
        $sql = 'DELETE FROM billoperation WHERE sydate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM billoperation WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BilloperationMySql
     */
    protected function readRow($row) {
        $billoperation = new Billoperation();

        $billoperation->id = $row['id'];
        $billoperation->name = $row['name'];
        $billoperation->userid = $row['userid'];
        $billoperation->sydate = $row['sydate'];
        $billoperation->del = $row['del'];
        $billoperation->treeId = $row['treeId'];

        return $billoperation;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BilloperationMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>